<?php
/*
Plugin Name: EMI Calculator
Description: A simple EMI calculator tool.
Version: 1.0
Author: KG Shrestha@iTech Net 
*/

function emi_calculator_shortcode()
{
    ob_start(); // Start output buffering
?>
    <div class="emi-calculator">
        <h3>EMI Calculator</h3>
        <form id="emiForm">
            <label>Loan Amount:</label>
            <input type="number" id="loanAmount" required><br><br>

            <label>Annual Interest Rate (%):</label>
            <input type="number" step="0.1" id="interestRate" required><br><br>

            <label>Loan Tenure (months):</label>
            <input type="number" id="loanTenure" required><br><br>

            <button type="button" onclick="calculateEMI()">Calculate</button>
        </form>
        <div id="emiResult"></div>
    </div>

    <script>
        function calculateEMI() {
            // Get values
            let principal = parseFloat(document.getElementById('loanAmount').value);
            let rate = parseFloat(document.getElementById('interestRate').value) / 1200; // Monthly rate
            let tenure = parseFloat(document.getElementById('loanTenure').value);

            // EMI formula: [P x R x (1+R)^N]/[(1+R)^N-1]
            let emi = (principal * rate * Math.pow(1 + rate, tenure)) / (Math.pow(1 + rate, tenure) - 1);

            // Display result
            document.getElementById('emiResult').innerHTML =
                `<h4>Monthly EMI Amount: ${emi.toFixed(2)}</h4>`;
        }
    </script>

    <style>
        .emi-calculator {
            padding: 20px;
            background: #f9f9f9;
            border-radius: 8px;
            max-width: 400px;
            margin: 20px auto;
        }

        input,
        button {
            width: 100%;
            padding: 8px;
            margin: 5px 0;
        }

        button {
            background: #0073aa;
            color: white;
            border: none;
            cursor: pointer;
        }
    </style>
<?php
    return ob_get_clean(); // Return the buffered output
}
add_shortcode('emi_calculator', 'emi_calculator_shortcode');
?>